/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import paulevs.betternether.BlocksHelper;
import paulevs.betternether.MHelper;
import paulevs.betternether.config.Configs;
import paulevs.betternether.world.NetherBiome;
import paulevs.betternether.world.features.CavesFeature;
import paulevs.betternether.world.structures.StructureGeneratorThreadContext;
import paulevs.betternether.world.structures.StructureType;
import ru.bclib.api.biomes.BiomeAPI;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.generator.GeneratorOptions;

public class BNWorldGenerator {
    private static final float ditherScale = Configs.GENERATOR.getFloat("generator.world", "dither_scale", 4.0f);
    private static float structureDensity;
    private static float lavaStructureDensity;
    private static float globalDensity;
    private class_2338.class_2339 popPos = new class_2338.class_2339();
    private final NetherBiome[][][] BIOMES = new NetherBiome[8][8][8];
    private final List<class_2338> LIST_FLOOR = new ArrayList<class_2338>(4096);
    private final List<class_2338> LIST_WALL = new ArrayList<class_2338>(4096);
    private final List<class_2338> LIST_CEIL = new ArrayList<class_2338>(4096);
    private final List<class_2338> LIST_LAVA = new ArrayList<class_2338>(1024);
    private final HashSet<class_6880<class_1959>> MC_BIOMES = new HashSet();
    private NetherBiome biome;
    public final StructureGeneratorThreadContext context = new StructureGeneratorThreadContext();

    public static void onModInit() {
        structureDensity = Configs.GENERATOR.getFloat("generator.world", "structures_density", 0.0625f) * 1.0001f;
        lavaStructureDensity = Configs.GENERATOR.getFloat("generator.world", "lava_structures_density", 0.005f) * 1.0001f;
        globalDensity = Configs.GENERATOR.getFloat("generator.world", "global_plant_and_structures_density", 1.0f) * 1.0001f;
    }

    private static int clamp(int x, int max) {
        return x < 0 ? 0 : (x > max ? max : x);
    }

    public void populate(class_5281 world, int sx, int sz, class_5821<class_3111> featurePlaceContext) {
        Random random = featurePlaceContext.method_33654();
        int MAX_HEIGHT = featurePlaceContext.method_33653().method_12104();
        int layerHeight = BNWorldGenerator.getLayerHeight(MAX_HEIGHT);
        if (random.nextFloat() < structureDensity) {
            this.popPos.method_10103(sx + random.nextInt(16), MHelper.randRange(33, MAX_HEIGHT - 28, random), sz + random.nextInt(16));
            StructureType type = StructureType.FLOOR;
            boolean isAir = world.method_8320((class_2338)this.popPos).method_26207().method_15800();
            boolean airUp = world.method_8320(this.popPos.method_10084()).method_26207().method_15800() && world.method_8320(this.popPos.method_10086(3)).method_26207().method_15800();
            boolean airDown = world.method_8320(this.popPos.method_10074()).method_26207().method_15800() && world.method_8320(this.popPos.method_10087(3)).method_26207().method_15800();
            NetherBiome biome = this.getBiomeLocal(this.popPos.method_10263() - sx, this.popPos.method_10264(), this.popPos.method_10260() - sz, random, layerHeight, world, (class_2338)this.popPos);
            if (!(isAir || airUp || airDown || random.nextInt(8) != 0)) {
                type = StructureType.UNDER;
            } else if (this.popPos.method_10264() < 45 || biome != null && !biome.hasCeilStructures() || random.nextBoolean()) {
                if (!isAir) {
                    while (!world.method_8320((class_2338)this.popPos).method_26207().method_15800() && this.popPos.method_10264() > 1) {
                        this.popPos.method_33098(this.popPos.method_10264() - 1);
                    }
                }
                while (world.method_8320(this.popPos.method_10074()).method_26207().method_15800() && this.popPos.method_10264() > 1) {
                    this.popPos.method_33098(this.popPos.method_10264() - 1);
                }
            } else {
                if (!isAir) {
                    while (!world.method_8320((class_2338)this.popPos).method_26207().method_15800() && this.popPos.method_10264() > 1) {
                        this.popPos.method_33098(this.popPos.method_10264() + 1);
                    }
                }
                while (!BlocksHelper.isNetherGroundMagma(world.method_8320(this.popPos.method_10084())) && this.popPos.method_10264() < 127) {
                    this.popPos.method_33098(this.popPos.method_10264() + 1);
                }
                type = StructureType.CEIL;
            }
            biome = this.getBiomeLocal(this.popPos.method_10263() - sx, this.popPos.method_10264(), this.popPos.method_10260() - sz, random, layerHeight, world, (class_2338)this.popPos);
            if (biome != null) {
                if (world.method_8320((class_2338)this.popPos).method_26207().method_15800()) {
                    class_2680 up;
                    if (type == StructureType.FLOOR) {
                        class_2680 down = world.method_8320(this.popPos.method_10074());
                        if (BlocksHelper.isNetherGroundMagma(down)) {
                            biome.genFloorBuildings((class_5425)world, (class_2338)this.popPos, random, MAX_HEIGHT, this.context);
                        }
                    } else if (type == StructureType.CEIL && BlocksHelper.isNetherGroundMagma(up = world.method_8320(this.popPos.method_10084()))) {
                        biome.genCeilBuildings((class_5425)world, (class_2338)this.popPos, random, MAX_HEIGHT, this.context);
                    }
                } else {
                    biome.genUnderBuildings((class_5425)world, (class_2338)this.popPos, random, MAX_HEIGHT, this.context);
                }
            }
        }
        if (random.nextFloat() < lavaStructureDensity) {
            this.popPos.method_10103(sx + random.nextInt(16), 32, sz + random.nextInt(16));
            if (world.method_22347((class_2338)this.popPos) && BlocksHelper.isLava(world.method_8320(this.popPos.method_10074()))) {
                this.biome = this.getBiomeLocal(this.popPos.method_10263() - sx, this.popPos.method_10264(), this.popPos.method_10260() - sz, random, layerHeight, world, (class_2338)this.popPos);
                if (this.biome != null) {
                    this.biome.genLavaBuildings((class_5425)world, (class_2338)this.popPos, random, MAX_HEIGHT, this.context);
                }
            }
        }
        this.LIST_LAVA.clear();
        this.LIST_FLOOR.clear();
        this.LIST_WALL.clear();
        this.LIST_CEIL.clear();
        int ex = sx + 16;
        int ez = sz + 16;
        for (int x = 0; x < 16; ++x) {
            int wx = sx + x;
            for (int z = 0; z < 16; ++z) {
                int wz = sz + z;
                for (int y = 1; y < MAX_HEIGHT - 2; ++y) {
                    if (CavesFeature.isInCave(x, y, z)) continue;
                    this.biome = this.getBiomeLocal(x, y, z, random, layerHeight, world, (class_2338)this.popPos);
                    if (this.biome == null) continue;
                    this.popPos.method_10103(wx, y, wz);
                    class_2680 state = world.method_8320((class_2338)this.popPos);
                    boolean lava = BlocksHelper.isLava(state);
                    if (!lava && !BlocksHelper.isNetherGroundMagma(state) && state.method_26204() != class_2246.field_10255) continue;
                    if (!(lava || !(state = world.method_8320(this.popPos.method_10084())).method_26215() && state.method_26207().method_15804() && state.method_26207().method_15801() || !state.method_26227().method_15769())) {
                        this.biome.genSurfColumn((class_1936)world, (class_2338)this.popPos, random);
                    }
                    if ((x + y + z & 1) != 0 || !(random.nextFloat() < globalDensity) || !(random.nextFloat() < this.biome.getPlantDensity())) continue;
                    if (world.method_22347(this.popPos.method_10084())) {
                        if (lava) {
                            this.LIST_LAVA.add(this.popPos.method_10084());
                            continue;
                        }
                        this.LIST_FLOOR.add(new class_2338((class_2382)this.popPos.method_10084()));
                        continue;
                    }
                    if (world.method_22347(this.popPos.method_10074())) {
                        this.LIST_CEIL.add(new class_2338((class_2382)this.popPos.method_10074()));
                        continue;
                    }
                    boolean bNorth = world.method_22347(this.popPos.method_10095());
                    boolean bSouth = world.method_22347(this.popPos.method_10072());
                    boolean bEast = world.method_22347(this.popPos.method_10078());
                    boolean bWest = world.method_22347(this.popPos.method_10067());
                    if (!bNorth && !bSouth && !bEast && !bWest) continue;
                    class_2338 objPos = null;
                    objPos = bNorth ? this.popPos.method_10095() : (bSouth ? this.popPos.method_10072() : (bEast ? this.popPos.method_10078() : this.popPos.method_10067()));
                    if (this.popPos.method_10263() < sx || this.popPos.method_10263() >= ex || this.popPos.method_10260() < sz || this.popPos.method_10260() >= ez) continue;
                    boolean bDown = world.method_22347(objPos.method_10074());
                    boolean bUp = world.method_22347(objPos.method_10084());
                    if (!bDown || !bUp) continue;
                    this.LIST_WALL.add(new class_2338((class_2382)objPos));
                }
            }
        }
        for (class_2338 pos : this.LIST_LAVA) {
            if (!world.method_22347(pos)) continue;
            this.biome = this.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random, layerHeight, world, (class_2338)this.popPos);
            if (this.biome == null) continue;
            this.biome.genLavaObjects((class_5425)world, pos, random, MAX_HEIGHT, this.context);
        }
        for (class_2338 pos : this.LIST_FLOOR) {
            if (!world.method_22347(pos)) continue;
            this.biome = this.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random, layerHeight, world, (class_2338)this.popPos);
            if (this.biome == null) continue;
            this.biome.genFloorObjects((class_5425)world, pos, random, MAX_HEIGHT, this.context);
        }
        for (class_2338 pos : this.LIST_WALL) {
            if (!world.method_22347(pos)) continue;
            this.biome = this.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random, layerHeight, world, (class_2338)this.popPos);
            if (this.biome == null) continue;
            this.biome.genWallObjects((class_5425)world, pos, random, MAX_HEIGHT, this.context);
        }
        for (class_2338 pos : this.LIST_CEIL) {
            if (!world.method_22347(pos)) continue;
            this.biome = this.getBiomeLocal(pos.method_10263() - sx, pos.method_10264(), pos.method_10260() - sz, random, layerHeight, world, (class_2338)this.popPos);
            if (this.biome == null) continue;
            this.biome.genCeilObjects((class_5425)world, pos, random, MAX_HEIGHT, this.context);
        }
    }

    private static int getLayerHeight(int MAX_HEIGHT) {
        int layerHeight = MAX_HEIGHT;
        if (MAX_HEIGHT > 128 && GeneratorOptions.useVerticalBiomes()) {
            layerHeight = MAX_HEIGHT / 8;
        }
        return layerHeight;
    }

    private void makeLocalBiomes(class_5281 world, int sx, int sz, class_5821<class_3111> featurePlaceContext) {
        int MAX_HEIGHT = featurePlaceContext.method_33653().method_12104();
        int layerHeight = BNWorldGenerator.getLayerHeight(MAX_HEIGHT);
        this.MC_BIOMES.clear();
        this.popPos.method_33098(5);
        int ySteps = MAX_HEIGHT <= 128 ? 1 : 8;
        for (int x = 0; x < 8; ++x) {
            this.popPos.method_33097(sx + (x << 1) + 2);
            for (int y = 0; y < ySteps; ++y) {
                this.popPos.method_33098((int)((double)(y * layerHeight) + 0.5 * (double)layerHeight));
                for (int z = 0; z < 8; ++z) {
                    NetherBiome nBiome;
                    this.popPos.method_33099(sz + (z << 1) + 2);
                    class_6880 b = world.method_23753((class_2338)this.popPos);
                    BCLBiome bCLBiome = BiomeAPI.getFromBiome((class_6880)b);
                    this.BIOMES[x][z][y] = bCLBiome instanceof NetherBiome ? (nBiome = (NetherBiome)bCLBiome) : null;
                    this.MC_BIOMES.add((class_6880<class_1959>)b);
                }
            }
        }
    }

    public void prePopulate(class_5281 world, int sx, int sz, class_5821<class_3111> featurePlaceContext) {
        this.context.clear();
        this.makeLocalBiomes(world, sx, sz, featurePlaceContext);
    }

    private NetherBiome getBiomeLocal(int x, int y, int z, Random random, int layerHeight, class_5281 world, class_2338 pos) {
        int px = Math.round((float)x + (random.nextFloat() - 0.5f) * 2.0f * ditherScale);
        int pz = (int)Math.round((double)z + ((double)random.nextFloat() - 0.5) * 12.0 * (double)ditherScale);
        int py = y / layerHeight;
        return this.BIOMES[BNWorldGenerator.clamp(px, 7)][BNWorldGenerator.clamp(pz, 7)][BNWorldGenerator.clamp(py, 7)];
    }
}

